/*
 * Decompiled with CFR 0.152.
 */
package kuzminki.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import kuzminki.api.KuzminkiError;
import kuzminki.jdbc.SingleConnection$;
import kuzminki.render.RenderedOperation;
import kuzminki.render.RenderedQuery;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.ZIO;
import zio.ZIO$;

@ScalaSignature(bytes="\u0006\u0005\u0005=r!B\u0007\u000f\u0011\u0003\u0019b!B\u000b\u000f\u0011\u00031\u0002\"B\u000f\u0002\t\u0003q\u0002\"B\u0010\u0002\t\u0003\u0001c\u0001B\u000b\u000f\u0001\tB\u0001b\t\u0003\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006;\u0011!\t\u0001\f\u0005\u0006]\u0011!Ia\f\u0005\u0006\u0005\u0012!Ia\u0011\u0005\u00067\u0012!\t\u0001\u0018\u0005\u0006w\u0012!\t\u0001 \u0005\b\u0003\u000b!A\u0011AA\u0004\u0011\u001d\ti\u0001\u0002C\u0001\u0003\u001f\t\u0001cU5oO2,7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005=\u0001\u0012\u0001\u00026eE\u000eT\u0011!E\u0001\tWVTX.\u001b8lS\u000e\u0001\u0001C\u0001\u000b\u0002\u001b\u0005q!\u0001E*j]\u001edWmQ8o]\u0016\u001cG/[8o'\t\tq\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\taa\u0019:fCR,G#B\u0011\u0002\u001c\u0005}\u0001C\u0001\u000b\u0005'\t!q#\u0001\u0003d_:t\u0007CA\u0013+\u001b\u00051#BA\u0014)\u0003\r\u0019\u0018\u000f\u001c\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0006D_:tWm\u0019;j_:$\"!I\u0017\t\u000b\r2\u0001\u0019\u0001\u0013\u0002\rM,G/\u0011:h)\u0011\u00014\u0007O\u001f\u0011\u0005a\t\u0014B\u0001\u001a\u001a\u0005\u0011)f.\u001b;\t\u000bQ:\u0001\u0019A\u001b\u0002\u000f)$'mY*u[B\u0011QEN\u0005\u0003o\u0019\u0012\u0011\u0003\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u\u0011\u0015It\u00011\u0001;\u0003\r\t'o\u001a\t\u00031mJ!\u0001P\r\u0003\u0007\u0005s\u0017\u0010C\u0003?\u000f\u0001\u0007q(A\u0003j]\u0012,\u0007\u0010\u0005\u0002\u0019\u0001&\u0011\u0011)\u0007\u0002\u0004\u0013:$\u0018\u0001D4fiN#\u0018\r^3nK:$HcA\u001bE!\")q\u0005\u0003a\u0001\u000bB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\r\u000e\u0003%S!A\u0013\n\u0002\rq\u0012xn\u001c;?\u0013\ta\u0015$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'\u001a\u0011\u0015\t\u0006\u00021\u0001S\u0003\u0011\t'oZ:\u0011\u0007MC&H\u0004\u0002U-:\u0011\u0001*V\u0005\u00025%\u0011q+G\u0001\ba\u0006\u001c7.Y4f\u0013\tI&L\u0001\u0004WK\u000e$xN\u001d\u0006\u0003/f\tQ!];fef,\"!X7\u0015\u0005y\u001b\b\u0003B0fu!t!\u0001Y2\u000f\u0005!\u000b\u0017\"\u00012\u0002\u0007iLw.\u0003\u0002XI*\t!-\u0003\u0002gO\n\u0019!+S(\u000b\u0005]#\u0007cA*jW&\u0011!N\u0017\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002m[2\u0001A!\u00028\n\u0005\u0004y'!\u0001*\u0012\u0005AT\u0004C\u0001\rr\u0013\t\u0011\u0018DA\u0004O_RD\u0017N\\4\t\u000bQL\u0001\u0019A;\u0002\u0007M$X\u000eE\u0002ws.l\u0011a\u001e\u0006\u0003qB\taA]3oI\u0016\u0014\u0018B\u0001>x\u00055\u0011VM\u001c3fe\u0016$\u0017+^3ss\u0006!Q\r_3d)\tih\u0010\u0005\u0003`Kj\u0002\u0004\"\u0002;\u000b\u0001\u0004y\bc\u0001<\u0002\u0002%\u0019\u00111A<\u0003#I+g\u000eZ3sK\u0012|\u0005/\u001a:bi&|g.A\u0004fq\u0016\u001cg*^7\u0015\t\u0005%\u00111\u0002\t\u0005?\u0016Tt\bC\u0003u\u0017\u0001\u0007q0A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0012A)\u00111CA\fa9\u0019\u0011QC2\u000e\u0003\u0011L1!!\u0007h\u0005\u0011!\u0016m]6\t\r\u0005u1\u00011\u0001F\u0003\r)(\u000f\u001c\u0005\b\u0003C\u0019\u0001\u0019AA\u0012\u0003\u0015\u0001(o\u001c9t!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"bAA\u0015Q\u0005!Q\u000f^5m\u0013\u0011\ti#a\n\u0003\u0015A\u0013x\u000e]3si&,7\u000f")
public class SingleConnection {
    private final Connection conn;

    public static SingleConnection create(String url, Properties props) {
        return SingleConnection$.MODULE$.create(url, props);
    }

    private void setArg(PreparedStatement jdbcStm, Object arg, int index) {
        Object object = arg;
        if (object instanceof String) {
            String string = (String)object;
            jdbcStm.setString(index, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            jdbcStm.setBoolean(index, bl);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            jdbcStm.setShort(index, s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            jdbcStm.setInt(index, n);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            jdbcStm.setLong(index, l);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            jdbcStm.setFloat(index, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            jdbcStm.setDouble(index, d);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            jdbcStm.setBigDecimal(index, bigDecimal.bigDecimal());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Time) {
            Time time = (Time)object;
            jdbcStm.setTime(index, time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            jdbcStm.setDate(index, date);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            jdbcStm.setTimestamp(index, timestamp);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new KuzminkiError(new StringBuilder(21).append("type not supported [").append(arg).append("]").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private PreparedStatement getStatement(String sql2, Vector<Object> args) {
        void var3_3;
        block0: {
            PreparedStatement jdbcStm = this.conn.prepareStatement(sql2);
            if (!args.nonEmpty()) break block0;
            ((Vector)args.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                SingleConnection.$anonfun$getStatement$1(this, jdbcStm, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    public <R> ZIO<Object, Throwable, List<R>> query(RenderedQuery<R> stm) {
        return ZIO$.MODULE$.attemptBlocking((Function0 & Serializable)() -> {
            PreparedStatement jdbcStm = this.getStatement(stm.statement(), stm.args());
            ResultSet jdbcResultSet = jdbcStm.executeQuery();
            ListBuffer buff = ListBuffer$.MODULE$.empty();
            while (jdbcResultSet.next()) {
                buff.$plus$eq(stm.rowConv().fromRow(jdbcResultSet));
            }
            jdbcResultSet.close();
            jdbcStm.close();
            return buff.toList();
        }, (Object)"kuzminki.jdbc.SingleConnection.query(SingleConnection.scala:86)");
    }

    public ZIO<Object, Throwable, BoxedUnit> exec(RenderedOperation stm) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            PreparedStatement jdbcStm = this.getStatement(stm.statement(), stm.args());
            jdbcStm.execute();
            jdbcStm.close();
        }, (Object)"kuzminki.jdbc.SingleConnection.exec(SingleConnection.scala:100)");
    }

    public ZIO<Object, Throwable, Object> execNum(RenderedOperation stm) {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            void var3_3;
            PreparedStatement jdbcStm = this.getStatement(stm.statement(), stm.args());
            int num = jdbcStm.executeUpdate();
            jdbcStm.close();
            return (int)var3_3;
        }, (Object)"kuzminki.jdbc.SingleConnection.execNum(SingleConnection.scala:109)");
    }

    public ZIO<Object, Throwable, BoxedUnit> close() {
        return ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.conn.close(), (Object)"kuzminki.jdbc.SingleConnection.close(SingleConnection.scala:118)");
    }

    public static final /* synthetic */ void $anonfun$getStatement$1(SingleConnection $this, PreparedStatement jdbcStm$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object arg = tuple2._1();
        int index = tuple2._2$mcI$sp();
        $this.setArg(jdbcStm$1, arg, index + 1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SingleConnection(Connection conn) {
        this.conn = conn;
    }
}

