/*
 * Decompiled with CFR 0.152.
 */
package kuzminki.api;

import java.util.Properties;
import kuzminki.api.DbConfig;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a4AAF\f\u00019!A1\u0005\u0001B\u0001B\u0003%A\u0005C\u00030\u0001\u0011\u0005\u0001\u0007C\u00045\u0001\u0001\u0007I\u0011B\u001b\t\u000fe\u0002\u0001\u0019!C\u0005u!1\u0001\t\u0001Q!\nYBq!\u0011\u0001A\u0002\u0013%!\tC\u0004G\u0001\u0001\u0007I\u0011B$\t\r%\u0003\u0001\u0015)\u0003D\u0011\u001dQ\u0005\u00011A\u0005\n\tCqa\u0013\u0001A\u0002\u0013%A\n\u0003\u0004O\u0001\u0001\u0006Ka\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019I\u0006\u0001)A\u0005#\")!\f\u0001C\u00057\")A\f\u0001C\u0001;\")\u0001\r\u0001C\u0001C\")1\r\u0001C\u0001I\")a\r\u0001C\u0001O\")\u0011\u000e\u0001C\u0001U\")A\u000e\u0001C\u0001[\")1\u000f\u0001C\u0001i\nyAIY\"p]\u001aLwMQ;jY\u0012,'O\u0003\u0002\u00193\u0005\u0019\u0011\r]5\u000b\u0003i\t\u0001b[;{[&t7.[\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001fC5\tqDC\u0001!\u0003\u0015\u00198-\u00197b\u0013\t\u0011sD\u0001\u0004B]f\u0014VMZ\u0001\u0007I\nt\u0015-\\3\u0011\u0005\u0015bcB\u0001\u0014+!\t9s$D\u0001)\u0015\tI3$\u0001\u0004=e>|GOP\u0005\u0003W}\ta\u0001\u0015:fI\u00164\u0017BA\u0017/\u0005\u0019\u0019FO]5oO*\u00111fH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u001a\u0004C\u0001\u001a\u0001\u001b\u00059\u0002\"B\u0012\u0003\u0001\u0004!\u0013\u0001\u00039p_2\u001c\u0016N_3\u0016\u0003Y\u0002\"AH\u001c\n\u0005az\"aA%oi\u0006a\u0001o\\8m'&TXm\u0018\u0013fcR\u00111H\u0010\t\u0003=qJ!!P\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b\u007f\u0011\t\t\u00111\u00017\u0003\rAH%M\u0001\na>|GnU5{K\u0002\nq\u0001[8ti>\u0003H/F\u0001D!\rqB\tJ\u0005\u0003\u000b~\u0011aa\u00149uS>t\u0017a\u00035pgR|\u0005\u000f^0%KF$\"a\u000f%\t\u000f}:\u0011\u0011!a\u0001\u0007\u0006A\u0001n\\:u\u001fB$\b%A\u0004q_J$x\n\u001d;\u0002\u0017A|'\u000f^(qi~#S-\u001d\u000b\u0003w5Cqa\u0010\u0006\u0002\u0002\u0003\u00071)\u0001\u0005q_J$x\n\u001d;!\u0003\u0015\u0001(o\u001c9t+\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011)H/\u001b7\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00029s_B\u001c\b%\u0001\u0004hKR,&\u000f\\\u000b\u0002I\u0005aq/\u001b;i!>|GnU5{KR\u0011\u0011G\u0018\u0005\u0006?>\u0001\rAN\u0001\u0006m\u0006dW/Z\u0001\to&$\b\u000eS8tiR\u0011\u0011G\u0019\u0005\u0006?B\u0001\r\u0001J\u0001\to&$\b\u000eU8siR\u0011\u0011'\u001a\u0005\u0006?F\u0001\r\u0001J\u0001\to&$\b.V:feR\u0011\u0011\u0007\u001b\u0005\u0006?J\u0001\r\u0001J\u0001\ro&$\b\u000eU1tg^|'\u000f\u001a\u000b\u0003c-DQaX\nA\u0002\u0011\n1b^5uQ>\u0003H/[8ogR\u0011\u0011G\u001c\u0005\u0006_R\u0001\r\u0001]\u0001\b_B$\u0018n\u001c8t!\u0011)\u0013\u000f\n\u0013\n\u0005It#aA'ba\u0006Iq-\u001a;D_:4\u0017nZ\u000b\u0002kB\u0011!G^\u0005\u0003o^\u0011\u0001\u0002\u00122D_:4\u0017n\u001a")
public class DbConfigBuilder {
    private final String dbName;
    private int poolSize;
    private Option<String> hostOpt;
    private Option<String> portOpt;
    private final Properties props;

    private int poolSize() {
        return this.poolSize;
    }

    private void poolSize_$eq(int x$1) {
        this.poolSize = x$1;
    }

    private Option<String> hostOpt() {
        return this.hostOpt;
    }

    private void hostOpt_$eq(Option<String> x$1) {
        this.hostOpt = x$1;
    }

    private Option<String> portOpt() {
        return this.portOpt;
    }

    private void portOpt_$eq(Option<String> x$1) {
        this.portOpt = x$1;
    }

    private Properties props() {
        return this.props;
    }

    private String getUrl() {
        String host = (String)this.hostOpt().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "localhost");
        String port = (String)this.portOpt().getOrElse((Function0 & java.io.Serializable & Serializable)() -> "5432");
        return new StringBuilder(20).append("jdbc:postgresql://").append(host).append(":").append(port).append("/").append(this.dbName).toString();
    }

    public DbConfigBuilder withPoolSize(int value) {
        this.poolSize_$eq(value);
        return this;
    }

    public DbConfigBuilder withHost(String value) {
        this.hostOpt_$eq((Option<String>)new Some((Object)value));
        return this;
    }

    public DbConfigBuilder withPort(String value) {
        this.portOpt_$eq((Option<String>)new Some((Object)value));
        return this;
    }

    public DbConfigBuilder withUser(String value) {
        this.props().setProperty("user", value);
        return this;
    }

    public DbConfigBuilder withPassword(String value) {
        this.props().setProperty("password", value);
        return this;
    }

    public DbConfigBuilder withOptions(Map<String, String> options) {
        options.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            Object object = this.props().setProperty(key, value);
            return object;
        });
        return this;
    }

    public DbConfig getConfig() {
        return new DbConfig(this.getUrl(), this.props(), this.poolSize());
    }

    public DbConfigBuilder(String dbName) {
        this.dbName = dbName;
        this.poolSize = 10;
        this.hostOpt = None$.MODULE$;
        this.portOpt = None$.MODULE$;
        this.props = new Properties();
    }
}

