/*
 * Decompiled with CFR 0.152.
 */
package kuzminki.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import kuzminki.api.KuzminkiError;
import kuzminki.jdbc.SingleConnection$;
import kuzminki.render.RenderedOperation;
import kuzminki.render.RenderedQuery;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import zio.Has;
import zio.ZIO;
import zio.blocking.package;
import zio.blocking.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}r!B\u0007\u000f\u0011\u0003\u0019b!B\u000b\u000f\u0011\u00031\u0002\"B\u000f\u0002\t\u0003q\u0002\"B\u0010\u0002\t\u0003\u0001c\u0001B\u000b\u000f\u0001\tB\u0001b\t\u0003\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006;\u0011!\t\u0001\f\u0005\u0006]\u0011!Ia\f\u0005\u0006\u0005\u0012!Ia\u0011\u0005\u00067\u0012!\t\u0001\u0018\u0005\b\u0003\u0017!A\u0011AA\u0007\u0011\u001d\tI\u0002\u0002C\u0001\u00037Aq!!\t\u0005\t\u0003\t\u0019#\u0001\tTS:<G.Z\"p]:,7\r^5p]*\u0011q\u0002E\u0001\u0005U\u0012\u00147MC\u0001\u0012\u0003!YWO_7j].L7\u0001\u0001\t\u0003)\u0005i\u0011A\u0004\u0002\u0011'&tw\r\\3D_:tWm\u0019;j_:\u001c\"!A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1#\u0001\u0004de\u0016\fG/\u001a\u000b\u0006C\u0005-\u0012q\u0006\t\u0003)\u0011\u0019\"\u0001B\f\u0002\t\r|gN\u001c\t\u0003K)j\u0011A\n\u0006\u0003O!\n1a]9m\u0015\u0005I\u0013\u0001\u00026bm\u0006L!a\u000b\u0014\u0003\u0015\r{gN\\3di&|g\u000e\u0006\u0002\"[!)1E\u0002a\u0001I\u000511/\u001a;Be\u001e$B\u0001M\u001a9{A\u0011\u0001$M\u0005\u0003ee\u0011A!\u00168ji\")Ag\u0002a\u0001k\u00059!\u000e\u001a2d'Rl\u0007CA\u00137\u0013\t9dEA\tQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RDQ!O\u0004A\u0002i\n1!\u0019:h!\tA2(\u0003\u0002=3\t\u0019\u0011I\\=\t\u000by:\u0001\u0019A \u0002\u000b%tG-\u001a=\u0011\u0005a\u0001\u0015BA!\u001a\u0005\rIe\u000e^\u0001\rO\u0016$8\u000b^1uK6,g\u000e\u001e\u000b\u0004k\u0011\u0003\u0006\"B\u0014\t\u0001\u0004)\u0005C\u0001$N\u001d\t95\n\u0005\u0002I35\t\u0011J\u0003\u0002K%\u00051AH]8pizJ!\u0001T\r\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019fAQ!\u0015\u0005A\u0002I\u000bA!\u0019:hgB\u00191\u000b\u0017\u001e\u000f\u0005Q3fB\u0001%V\u0013\u0005Q\u0012BA,\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\rY+7\r^8s\u0015\t9\u0016$A\u0003rk\u0016\u0014\u00180\u0006\u0002^oR\u0011a, \t\u0005?\u0016D'O\u0004\u0002aG:\u0011\u0001*Y\u0005\u0002E\u0006\u0019!0[8\n\u0005]#'\"\u00012\n\u0005\u0019<'a\u0001*J\u001f*\u0011q\u000b\u001a\t\u0003S>t!A[7\u000f\u0005\u0001\\\u0017B\u00017e\u0003!\u0011Gn\\2lS:<\u0017BA,o\u0015\taG-\u0003\u0002qc\nA!\t\\8dW&twM\u0003\u0002X]B\u00191k];\n\u0005QT&\u0001\u0002'jgR\u0004\"A^<\r\u0001\u0011)\u00010\u0003b\u0001s\n\t!+\u0005\u0002{uA\u0011\u0001d_\u0005\u0003yf\u0011qAT8uQ&tw\rC\u0003\u007f\u0013\u0001\u0007q0A\u0002ti6\u0004R!!\u0001\u0002\bUl!!a\u0001\u000b\u0007\u0005\u0015\u0001#\u0001\u0004sK:$WM]\u0005\u0005\u0003\u0013\t\u0019AA\u0007SK:$WM]3e#V,'/_\u0001\u0005Kb,7\r\u0006\u0003\u0002\u0010\u0005E\u0001\u0003B0fQBBaA \u0006A\u0002\u0005M\u0001\u0003BA\u0001\u0003+IA!a\u0006\u0002\u0004\t\t\"+\u001a8eKJ,Gm\u00149fe\u0006$\u0018n\u001c8\u0002\u000f\u0015DXm\u0019(v[R!\u0011QDA\u0010!\u0011yV\r[ \t\ry\\\u0001\u0019AA\n\u0003\u0015\u0019Gn\\:f)\t\t)\u0003E\u0003\u0002(\u0015D\u0007GD\u0002\u0002*\rl\u0011\u0001\u001a\u0005\u0007\u0003[\u0019\u0001\u0019A#\u0002\u0007U\u0014H\u000eC\u0004\u00022\r\u0001\r!a\r\u0002\u000bA\u0014x\u000e]:\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f)\u0003\u0011)H/\u001b7\n\t\u0005u\u0012q\u0007\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b")
public class SingleConnection {
    private final Connection conn;

    public static SingleConnection create(String string, Properties properties) {
        return SingleConnection$.MODULE$.create(string, properties);
    }

    private void setArg(PreparedStatement jdbcStm, Object arg, int index) {
        Object object = arg;
        if (object instanceof String) {
            String string = (String)object;
            jdbcStm.setString(index, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            jdbcStm.setBoolean(index, bl);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            jdbcStm.setShort(index, s);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            jdbcStm.setInt(index, n);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            jdbcStm.setLong(index, l);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            jdbcStm.setFloat(index, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            jdbcStm.setDouble(index, d);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            jdbcStm.setBigDecimal(index, bigDecimal.bigDecimal());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Time) {
            Time time = (Time)object;
            jdbcStm.setTime(index, time);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            jdbcStm.setDate(index, date);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            jdbcStm.setTimestamp(index, timestamp);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new KuzminkiError(new StringBuilder(21).append("type not supported [").append(arg).append("]").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private PreparedStatement getStatement(String sql2, Vector<Object> args) {
        void var3_3;
        block0: {
            PreparedStatement jdbcStm = this.conn.prepareStatement(sql2);
            if (!args.nonEmpty()) break block0;
            ((IterableLike)args.zipWithIndex(Vector$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SingleConnection.$anonfun$getStatement$1(this, jdbcStm, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        return var3_3;
    }

    public <R> ZIO<Has<package.Blocking.Service>, Throwable, List<R>> query(RenderedQuery<R> stm) {
        return package$.MODULE$.effectBlocking((Function0 & Serializable & scala.Serializable)() -> {
            PreparedStatement jdbcStm = this.getStatement(stm.statement(), stm.args());
            ResultSet jdbcResultSet = jdbcStm.executeQuery();
            ListBuffer buff = (ListBuffer)ListBuffer$.MODULE$.empty();
            while (jdbcResultSet.next()) {
                buff.$plus$eq(stm.rowConv().fromRow(jdbcResultSet));
            }
            jdbcResultSet.close();
            jdbcStm.close();
            return buff.toList();
        });
    }

    public ZIO<Has<package.Blocking.Service>, Throwable, BoxedUnit> exec(RenderedOperation stm) {
        return package$.MODULE$.effectBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PreparedStatement jdbcStm = this.getStatement(stm.statement(), stm.args());
            jdbcStm.execute();
            jdbcStm.close();
        });
    }

    public ZIO<Has<package.Blocking.Service>, Throwable, Object> execNum(RenderedOperation stm) {
        return package$.MODULE$.effectBlocking((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            void var3_3;
            PreparedStatement jdbcStm = this.getStatement(stm.statement(), stm.args());
            int num = jdbcStm.executeUpdate();
            jdbcStm.close();
            return (int)var3_3;
        });
    }

    public ZIO<Has<package.Blocking.Service>, Throwable, BoxedUnit> close() {
        return package$.MODULE$.effectBlocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.conn.close());
    }

    public static final /* synthetic */ void $anonfun$getStatement$1(SingleConnection $this, PreparedStatement jdbcStm$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object arg = tuple2._1();
        int index = tuple2._2$mcI$sp();
        $this.setArg(jdbcStm$1, arg, index + 1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public SingleConnection(Connection conn) {
        this.conn = conn;
    }
}

